---
title: Respond with another site · Cloudflare Workers docs
description: Respond to the Worker request with the response from another
  website (example.com in this example).
lastUpdated: 2025-10-17T07:10:47.000Z
chatbotDeprioritize: false
tags: Middleware,JavaScript,TypeScript,Python
source_url:
  html: https://developers.cloudflare.com/workers/examples/respond-with-another-site/
  md: https://developers.cloudflare.com/workers/examples/respond-with-another-site/index.md
---

If you want to get started quickly, click on the button below.

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/docs-examples/tree/main/workers/respond-with-another-site)

This creates a repository in your GitHub account and deploys the application to Cloudflare Workers.

* JavaScript

  ```js
  export default {
    async fetch(request) {
      function MethodNotAllowed(request) {
        return new Response(`Method ${request.method} not allowed.`, {
          status: 405,
          headers: {
            Allow: "GET",
          },
        });
      }
      // Only GET requests work with this proxy.
      if (request.method !== "GET") return MethodNotAllowed(request);
      return fetch(`https://example.com`);
    },
  };
  ```

  [Run Worker in Playground](https://workers.cloudflare.com/playground#LYVwNgLglgDghgJwgegGYHsHALQBM4RwDcABAEbogB2+CAngLzbPYZb6HbW5QDGU2AAwBOAGwBmAKziJAdjHCAXCxZtgHOFxp8BIidLkKAsACgAwuioQAplewARKAGcY6J1GiXFJNXgLESKjhgawYAIigaawAPADoAKycw0lQoMFtg0IiouMSw0wsrWwhsABU6GGtvOBgYMD4CKEtkeLgANzgnXgRYCABqYHRccGtTUxjXJBJca1Q4cAgSAG8TEhJOuipeH2sIXgALAAoEawBHEGsnCABKZdW1n2peTyoSAFld-aGAOXQIAEEwGB0AB3ay4Y5nC5XW4rB4PE4QEAIV5UawgkgAJUurioTmshwABh8IF9cCQACRLE7nS4QWIhUlDAC+gT+6yBoPBsUJABo7vD4VcCCAnN4ACyCSS8+6Ckj7axwGYIMUCuUPQHAkHeMIAcQAoqUwjL1SRmSbBczrkRZWbbchkCQAPJUMB0EgG0okGnQiBOEggzAAawDHn2JFJzhIMAQ6GidFitqgqBIkNpVwZnyGJAAhAwGCQ9YawrdEcjXiSyb8AZywRCfXTrbayyidnsjoT9hAIDAxQ6YsE6tZYrx0MBCU21uaTMyiKYVMw1BotDx+EIxFIZOJ5KJhAVLDY7I4XG4PE0qN5fBpSEEQuFGUr-MkfGkMnewmRgWR8uYD8UyhUVTrLU9S8I0zSJJYYwmEsYTAHAkQAPqDMM6RhIo2QzLkSTMvOC5Lv4K46Ou+hbjuwjMKYQA)

* TypeScript

  ```ts
  export default {
    async fetch(request): Promise<Response> {
      function MethodNotAllowed(request) {
        return new Response(`Method ${request.method} not allowed.`, {
          status: 405,
          headers: {
            Allow: "GET",
          },
        });
      }
      // Only GET requests work with this proxy.
      if (request.method !== "GET") return MethodNotAllowed(request);
      return fetch(`https://example.com`);
    },
  } satisfies ExportedHandler;
  ```

* Python

  ```py
  from workers import WorkerEntrypoint, Response, fetch


  class Default(WorkerEntrypoint):
      def fetch(self, request):
          def method_not_allowed(request):
              msg = f'Method {request.method} not allowed.'
              headers = {"Allow": "GET"}
              return Response(msg, headers=headers, status=405)


          # Only GET requests work with this proxy.
          if request.method != "GET":
              return method_not_allowed(request)


          return fetch("https://example.com")
  ```
