---
title: Historical (2019) · Cloudflare Web Application Firewall (WAF) docs
description: Changes to WAF managed rulesets done in 2019.
lastUpdated: 2025-02-18T19:39:49.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/change-log/historical-2019/
  md: https://developers.cloudflare.com/waf/change-log/historical-2019/index.md
---

| Ruleset | Rule ID | Description | Change Date | Old Action | New Action |
| - | - | - | - | - | - |
| Cloudflare Specials | 100242 | Block Citrix Netscaler ADC -[CVE-2019-19781](https://nvd.nist.gov/vuln/detail/CVE-2019-19781) | Emergency, 2019-12-16 | N/A | Block |
| Cloudflare Specials | 100009CB | Improvement in Equation-like SQLi. Merge 100009CB\_BETA into 100009CB. | 2019-12-16 | Block | Block |
| Cloudflare Specials | 100191 | Improvement CVE-2019-11043 detection. Merge 100191\_BETA into 100191. | 2019-12-16 | Block | Block |
| Cloudflare OWASP | 9802140 | Minor change to reduce Gutenberg false positives | Emergency, 2019-11-25 | Scoring based | Scoring based |
| Cloudflare OWASP | 9802140\_JSON | Minor change to reduce Gutenberg false positives | Emergency, 2019-11-25 | Scoring based | Scoring based |
| Cloudflare OWASP | 9802141 | Minor change to reduce Gutenberg false positives | Emergency, 2019-11-25 | Scoring based | Scoring based |
| Cloudflare OWASP | 9802141\_JSON | Minor change to reduce Gutenberg false positives | Emergency, 2019-11-25 | Scoring based | Scoring based |
| Cloudflare OWASP | 960034 | Reduce false positives for requests made with HTTP 2 and 3 | Emergency, 2019-11-25 | Scoring based | Scoring based |
| Cloudflare Specials | 100148 | Disable outdated XSS rule by default | 2019-11-12 | Block | Disable |
| Cloudflare Specials | 100035C | Update valid Googlebot IP ranges | Emergency, 2019-11-07 | Block | Block |
| Cloudflare Specials | 100035D | Update valid Googlebot IP ranges | Emergency, 2019-11-07 | Disabled | Disabled |
| Cloudflare Specials | 100139A | Improve XSS detection. Merge 100139A\_BETA into 100139A. | 2019-11-04 | Disable | Disable |
| Cloudflare Specials | 100139B | Improve XSS detection. Merge 100139B\_BETA into 100139B. | 2019-11-04 | Block | Block |
| Cloudflare Specials | 100139C | Improve XSS detection. Merge 100139C\_BETA into 100139C. | 2019-11-04 | Block | Block |
| Cloudflare Specials | 100139D | Improve XSS detection | 2019-11-04 | N/A | Block |
| Cloudflare Specials | 100173 | Improve XSS detection | 2019-11-04 | N/A | Block |
| Cloudflare Specials | 100030SVG | Disable outdated XSS rule by default | 2019-11-04 | Block | Disable |
| Cloudflare Specials | 100021C | Disable outdated XSS rule by default | 2019-11-04 | Block | Disable |
| Cloudflare Specials | 100021CE | Disable outdated XSS rule by default | 2019-11-04 | Block | Disable |
| Cloudflare Specials | 100021CB | Disable outdated XSS rule by default | 2019-11-04 | Block | Disable |
| Cloudflare Specials | 100021D | Disable outdated XSS rule by default | 2019-11-04 | Block | Disable |
| Cloudflare Specials | 100107 | Disable outdated XSS rule by default | 2019-11-04 | Block | Disable |
| Cloudflare Specials | 100030 | Disable outdated XSS rule by default | 2019-11-04 | Block | Disable |
| Cloudflare Specials | 100030ARGS\_STRICT | Disable outdated XSS rule by default | 2019-11-04 | Challenge | Disable |
| Cloudflare Specials | 100021 | Disable outdated XSS rule by default | 2019-11-04 | Challenge | Disable |
| Cloudflare Specials | 100021B | Disable outdated XSS rule by default | 2019-11-04 | Block | Disable |
| Cloudflare Specials | 100021E | Disable outdated XSS rule by default | 2019-11-04 | Challenge | Disable |
| Cloudflare Specials | 100090 | Disable outdated XSS rule by default | 2019-11-04 | Block | Disable |
| Cloudflare Specials | 100091 | Disable outdated XSS rule by default | 2019-11-04 | Block | Disable |
| Cloudflare Specials | 100091B | Disable outdated XSS rule by default | 2019-11-04 | Block | Disable |
| Cloudflare Specials | 100092 | Disable outdated XSS rule by default | 2019-11-04 | Block | Disable |
| Cloudflare Specials | 100170 | Improve XSS detection. Merge 100170\_BETA into 100170. | 2019-11-04 | Block | Block |
| Cloudflare Specials | 100021H | Disable outdated XSS rule by default | 2019-11-04 | Block | Disable |
| Cloudflare Specials | 100044 | Disabled obsolete rule by default. Merge 100044\_BETA into 100044. | 2019-11-04 | Block | Disable |
| Cloudflare Specials | 100174 | Improve XSS detection | 2019-11-04 | N/A | Block |
| Cloudflare Specials | 100135B | Reduced false positive rate. Merge 100135B\_BETA into 100135B. | 2019-11-04 | Block | Block |
| Cloudflare Specials | 100191 | Block CVE-2019-11043 | Emergency, 2019-10-27 | N/A | Block |
| Cloudflare Specials | 100035C | Improve Fake Google Bot detection. Merge 100035C\_BETA into 100035C. | Emergency, 2019-10-23 | Block | Block |
| Cloudflare Specials | 100009CB | Improve Comparison-like SQL Injection detection. Merge 100009CB\_BETA into 100009CB. | 2019-10-21 | Block | Block |
| Cloudflare Specials | 100026 | Improve PHP Code Injection and File Upload detection | 2019-10-21 | Block | Block |
| Cloudflare Specials | 100186 | Block vBulletin vulnerability CVE-2019-17132 | 2019-10-21 | Log | Block |
| Cloudflare Specials | 100187 | Block vBulletin vulnerability CVE-2019-17132 | 2019-10-21 | Log | Block |
| Cloudflare Specials | 100035D | Improve Fake Google Bot detection. Merge 100035D\_BETA into 100035D. Change originally scheduled for 2019-10-21. | Emergency, 2019-10-17 | Disable | Disable |
| Cloudflare Specials | 100035 | Improve Fake Google Bot detection. Merge 100035\_BETA into 100035. Change originally scheduled for 2019-10-21. | Emergency, 2019-10-17 | Block | Block |
| Cloudflare Specials | 100035C | Improve Fake Google Bot detection. Merge 100035C\_BETA into 100035C. Change originally scheduled for 2019-10-21. | Emergency, 2019-10-17 | Block | Block |
| Cloudflare Specials | 100035B | Improve Fake Bing Bot detection. Merge 100035B\_BETA into 100035B. Change originally scheduled for 2019-10-21. | Emergency, 2019-10-17 | Block | Block |
| Cloudflare Specials | 100035Y | Improve Fake Yandex Bot detection. Merge 100035Y\_BETA into 100035Y. Change originally scheduled for 2019-10-21. | Emergency, 2019-10-17 | Block | Block |
| Cloudflare Specials | 100035U | Improve Fake Baidu Bot detection. Merge 100035U\_BETA into 100035U. Change originally scheduled for 2019-10-21. | Emergency, 2019-10-17 | Block | Block |
| Cloudflare Specials | 100135A | Improve XSS detection. Merge 100135A\_UBETA into 100135A. | 2019-10-14 | Block | Block |
| Cloudflare Specials | 100135B | Improve XSS detection. Merge 100135B\_UBETA into 100135B. | 2019-10-14 | Disable | Block |
| Cloudflare Specials | 100135C | Improve XSS detection. Merge 100135C\_UBETA into 100135C. | 2019-10-14 | Block | Block |
| Cloudflare Specials | 100136A | Improve XSS detection. Merge 100136A\_UBETA into 100136A. | 2019-10-14 | Block | Block |
| Cloudflare Specials | 100136B | Improve XSS detection. Merge 100136B\_UBETA into 100136B. | 2019-10-14 | Block | Block |
| Cloudflare Specials | 100136C | Improve XSS detection. Merge 100136C\_UBETA into 100136C. | 2019-10-14 | Block | Block |
| Cloudflare Specials | 100167 | Improve XSS and HTML Injection detection | 2019-10-14 | N/A | Block |
| Cloudflare Specials | 100168 | Improve XSS and HTML Injection detection | 2019-10-14 | N/A | Block |
| Cloudflare Specials | 100169 | Improve XSS and HTML Injection detection | 2019-10-14 | N/A | Disable |
| Cloudflare Specials | 100170 | Improve XSS and HTML Injection detection | 2019-10-14 | N/A | Block |
| Cloudflare Specials | 100171 | Improve XSS and HTML Injection detection | 2019-10-14 | N/A | Disable |
| Cloudflare Specials | 100172 | Improve XSS and HTML Injection detection | 2019-10-14 | N/A | Block |
| Cloudflare WordPress | WP0015 | Disables outdated WordPress rule by default. If this rule's action is set to anything other than the default, this change will have no effect. | 2019-10-07 | Block | Disable |
| Cloudflare Specials | 100008E | Improve SQLi protection | 2019-09-30 | Block | Block |
| Cloudflare Specials | 100008E | SQLi improvement | 2019-09-30 | Block | Block |
| Cloudflare Specials | 100166 | Block vBulletin[CVE-2019-16759](https://nvd.nist.gov/vuln/detail/CVE-2019-16759) | Emergency, 2019-09-26 | None | Block |
| Cloudflare OWASP | 9002140 | OWASP WordPress improvement | 2019-09-23 | Scoring based | Scoring based |
| Cloudflare OWASP | 9002140\_JSON | OWASP WordPress improvement | 2019-09-23 | Scoring based | Scoring based |
| Cloudflare OWASP | 9002141 | OWASP WordPress improvement | 2019-09-23 | Scoring based | Scoring based |
| Cloudflare OWASP | 9002141\_JSON | OWASP WordPress improvement | 2019-09-23 | Scoring based | Scoring based |
| Cloudflare Specials | 100162 | SQLi improvement on `SELECT FROM TABLE` statements | 2019-09-23 | N/A | Block |
| Cloudflare Specials | 100160 | JBoss protection improvement | 2019-09-16 | N/A | Block |
| Cloudflare OWASP | 9002140 | Small improvement to Gutenberg exception rules | 2019-09-09 | N/A | Scoring based |
| Cloudflare OWASP | 9002140\_JSON | Small improvement to Gutenberg exception rules | 2019-09-09 | N/A | Scoring based |
| Cloudflare OWASP | 9002141 | Small improvement to Gutenberg exception rules | 2019-09-09 | N/A | Scoring based |
| Cloudflare OWASP | 9002141\_JSON | Small improvement to Gutenberg exception rules | 2019-09-09 | N/A | Scoring based |
| Cloudflare Specials | 100158 | SQL Injection - Obfuscated `SELECT` expressions | 2019-09-09 | Log | Block |
| Cloudflare OWASP | URI-973326 | Small improvement in OWASP rule | 2019-09-09 | Scoring based | Scoring based |
| Cloudflare OWASP | 973326 | Small improvement in OWASP rule | 2019-09-09 | Scoring based | Scoring based |
| Cloudflare OWASP | URI-950901 | Remove OWASP rule | 2019-09-02 | Scoring based | N/A |
| Cloudflare OWASP | 959151 | Small improvement in OWASP rule | 2019-09-02 | Block | Block |
| Cloudflare OWASP | 950901 | Remove OWASP rule | 2019-09-02 | Scoring based | N/A |
| Cloudflare Drupal | D0003B | Disable rule by default | 2019-07-29 | Block | Disable |
| Cloudflare Specials | 100005A | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100007N | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100009DBETA | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100009I | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100009L | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100010B | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100021CD | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100030\_BETA | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100030ARGS\_LOOSE | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100035B2 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100035D | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100042 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100056\_BETA | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100057 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100059 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100061 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100062 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100062\_BETA | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100064 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100066 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100067 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100068 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100075 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100077 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100078B | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100083 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100084 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100085 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100086 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100088C | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100093 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100096BEVIL | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100096BHTML | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100096EVIL | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100096HTML | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100098 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100105 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100106B | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100107ARGS | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100108 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100108ARGS | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100109 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100109B | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100111 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100115 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100119 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100122 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100123B | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100126 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100131 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100133 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100135B | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100137 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100139A | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100140 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100146 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100146B | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100149 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100158 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Miscellaneous | CFMISC0004 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Miscellaneous | CFMISC0004B | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Miscellaneous | CFMISC0016B | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Drupal | D0005 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Drupal | D0016 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare PHP | PHP100008 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare PHP | PHP100009 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare PHP | PHP100010 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare PHP | PHP100011ARGS | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare PHP | PHP100011COOKIE | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare WordPress | WP0012 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare WordPress | WP0025C | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare WordPress | WP0028 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare WordPress | WP0030 | Disable rule by default | 2019-07-29 | Log | Disable |
| Cloudflare Specials | 100136A | Improve XSS JavaScript URI detection and reduce false positives | 2019-07-29 | Block | Block |
| Cloudflare Specials | 100136B | Improve XSS JavaScript URI detection and reduce false positives | 2019-07-29 | Block | Block |
| Cloudflare Specials | 100136C | Improve XSS JavaScript URI detection and reduce false positives | 2019-07-29 | Block | Block |
| Cloudflare Specials | 100135A | Improve XSS JavaScript Events detection and reduce false positives | 2019-07-29 | Block | Block |
| Cloudflare Specials | 100135B | Improve XSS JavaScript Events detection and reduce false positives | 2019-07-29 | Log | Block |
| Cloudflare Specials | 100135C | Improve XSS JavaScript Events detection and reduce false positives | 2019-07-29 | Block | Block |
| Cloudflare OWASP | 9002140 | Reduce WAF false positives for the Gutenberg WordPress editor | 2019-07-24 | N/A | Scoring based |
| Cloudflare OWASP | 9002140\_JSON | Reduce WAF false positives for the Gutenberg WordPress editor | 2019-07-24 | N/A | Scoring based |
| Cloudflare OWASP | 9002141 | Reduce WAF false positives for the Gutenberg WordPress editor | 2019-07-24 | N/A | Scoring based |
| Cloudflare OWASP | 9002141\_JSON | Reduce WAF false positives for the Gutenberg WordPress editor | 2019-07-24 | N/A | Scoring based |
| Cloudflare Specials | 100030 | Improve XSS HTML Script Tag detection | 2019-07-22 | Block | Block |
| Cloudflare Specials | 100153 | Block Oracle WebLogic - Command Injection -[CVE-2019-2729](https://nvd.nist.gov/vuln/detail/CVE-2019-2729) | 2019-06-27 | Block | Block |
| Cloudflare OWASP | 9002140A | Improve 9002140A | 2019-06-19 | Scoring based | Scoring based |
| Cloudflare OWASP | 9002140B | Improve 9002140B | 2019-06-19 | Scoring based | Scoring based |
| Cloudflare OWASP | 9002140A | Improve 9002140A | 2019-06-17 | Scoring based | Scoring based |
| Cloudflare OWASP | 9002140A | Improve 9002140B | 2019-06-17 | Scoring based | Scoring based |
| Cloudflare WordPress | WP0033 | Easy WP SMTP - Deserialization | 2019-06-17 | Log | Block |
| Cloudflare Specials | 100156 | XSS, HTML Injection - Malicious HTML Encoding | 2019-06-17 | Log | Block |
| Cloudflare OWASP | 9002140B\_BETA | Improve 9002140B | 2019-06-10 | Scoring based | Scoring based |
| Cloudflare Specials | 100005 | Improved shell variable normalization | 2019-06-10 | Block | Block |
| Cloudflare Specials | 100007NS | Improved shell variable normalization | 2019-06-10 | Block | Block |
| Cloudflare Specials | 100155 | PHPCMS - Dangerous File Upload -[CVE-2018-14399](https://nvd.nist.gov/vuln/detail/CVE-2018-14399) | 2019-06-10 | Log | Block |
| Cloudflare Specials | 100096BHTML | XSS, HTML Injection - Body | 2019-06-03 | N/A | Log |
| Cloudflare Specials | 100096BEVIL | XSS, HTML Injection - Body | 2019-06-03 | N/A | Log |
| Cloudflare OWASP | 9002140A | New OWASP rules to allow requests from the WordPress's Gutenberg editor | 2019-06-03 | N/A | Scoring based |
| Cloudflare OWASP | 9002140B | New OWASP rules to allow requests from the WordPress's Gutenberg editor | 2019-06-03 | N/A | Scoring based |
| All | All | Improve Rule Descriptions | 2019-05-28 | N/A | N/A |
| Cloudflare Specials | 100157 | Microsoft SharePoint Deserialization -[CVE-2019-0604](https://nvd.nist.gov/vuln/detail/CVE-2019-0604)(Strict) | 2019-05-28 | Block | Block |
| Cloudflare Specials | 100053 | Potential FI or Alias/Rewrite Bypass - Double Slash in URL | 2019-05-20 | Disable | Disable |
| Cloudflare Specials | 100122ARGS | Dangerous stream wrappers | 2019-05-20 | Block | Deprecated |
| Cloudflare Specials | 100122ARGS\_GET | Dangerous stream wrappers | 2019-05-20 | Block | Deprecated |
| Cloudflare Specials | 100122 | Dangerous stream wrappers | 2019-05-20 | Log | Block |
| Cloudflare Specials | 100157 | Microsoft SharePoint Deserialization -[CVE-2019-0604](https://nvd.nist.gov/vuln/detail/CVE-2019-0604) | 2019-05-13 | N/A | Block |
| Cloudflare Specials | 100154 | WordPress Social Warfare RCE/XSS ([CVE-2019-9978](https://nvd.nist.gov/vuln/detail/CVE-2019-9978)) | 2019-05-13 | Log | Block |
| Cloudflare OWASP | 9002140 | Reduce OWASP false positives | 2019-05-13 | Log | Allow |
| Cloudflare Specials | 100008 | Improve SQLi detection | 2019-05-13 | Block | Block |
| Cloudflare Specials | 100135A | Improve XSS detection and reduce false positives | 2019-05-07 | Block | Block |
| Cloudflare Specials | 100135B | Improve XSS detection and reduce false positives | 2019-05-07 | Log | Block |
| Cloudflare Specials | 100135C | Improve XSS detection and reduce false positives | 2019-05-07 | Block | Block |
| Cloudflare Specials | 100136A | Improve XSS detection and reduce false positives | 2019-05-07 | Block | Block |
| Cloudflare Specials | 100136B | Improve XSS detection and reduce false positives | 2019-05-07 | Block | Block |
| Cloudflare Specials | 100153 | Block Oracle WebLogic[CVE-2019-2725](https://nvd.nist.gov/vuln/detail/CVE-2019-2725),[CVE-2017-10271](https://nvd.nist.gov/vuln/detail/CVE-2017-10271),[CVE-2017-3506](https://nvd.nist.gov/vuln/detail/CVE-2017-3506) | 2019-05-07 | N/A | Block |
| Cloudflare Specials | 100148 | Improve inline XSS detection | 2019-05-07 | Log | Block |
| Cloudflare Specials | 100105HEADERS | PHP serialization in headers, excluding Cookies | 2019-05-07 | N/A | Block |
| Cloudflare Specials | 100146C | Potential SSRF attack | 2019-05-07 | Log | Block |
| Cloudflare Specials | 100106 | PostgreSQL COPY Injection | 2019-05-07 | Block | Block |
| Cloudflare Specials | 100139A | HTML Injection, XSS or Code Injection via data URI | 2019-05-07 | N/A | Log |
| Cloudflare Specials | 100139B | HTML Injection, XSS or Code Injection via data URI | 2019-05-07 | N/A | Block |
| Cloudflare Specials | 100139C | HTML Injection, XSS or Code Injection via data URI | 2019-05-07 | N/A | Block |
| Cloudflare Specials | 100105REFERER | PHP serialization in Referer header | 2019-04-29 | N/A | Block |
| Cloudflare Specials | 100152 | Joomla[CVE-2019-10945](https://nvd.nist.gov/vuln/detail/CVE-2019-10945) | 2019-04-29 | N/A | Block |
| Cloudflare Specials | 100144 | NoSQL Injection attack (Expression vector) | 2019-04-29 | Log | Block |
| Cloudflare Specials | 100143 | NoSQL Injection attack (comparison vector) | 2019-04-29 | Log | Block |
| Cloudflare Specials | 100148 | Improve XSS inline detection | 2019-04-29 | Log | Block |
| Cloudflare Specials | 100135A | Improve XSS detection | 2019-04-22 | Block | Block |
| Cloudflare Specials | 100135B | Improve XSS detection | 2019-04-22 | Block | Block |
| Cloudflare Specials | 100136A | Improve XSS detection | 2019-04-22 | Block | Block |
| Cloudflare Specials | 100136B | Improve XSS detection | 2019-04-22 | Block | Block |
| Cloudflare Specials | 100097G | Improve SQLi blocking | 2019-04-22 | Log | Block |
| Cloudflare WordPress | WP0034 | WordPress zero day XSS | 2019-04-22 | N/A | Block |
| Cloudflare Specials | 100010A | Improve SQLi detection | 2019-04-22 | Block | Block |
| Cloudflare PHP | PHP100013 | Blocks PHP CGI attack by default | 2019-04-22 | Log | Block |
| Cloudflare Specials | 100150 | Block[CVE-2019-10842](https://nvd.nist.gov/vuln/detail/CVE-2019-10842) | 2019-04-22 | N/A | Block |
| Cloudflare Specials | 100142 | NoSQL Injection attack (array vector) | 2019-04-15 | Log | Block |
| Cloudflare Specials | 100135A | Improve XSS event detection | 2019-04-08 | N/A | N/A |
| Cloudflare Specials | 100135B | Improve XSS event detection | 2019-04-08 | N/A | N/A |
| Cloudflare Specials | 100135C | Improve XSS event detection | 2019-04-08 | N/A | N/A |
| Cloudflare Specials | 100030SVG | Improve XSS event detection | 2019-04-08 | N/A | N/A |
| Cloudflare Specials | 100021C | Improve XSS event detection | 2019-04-08 | N/A | N/A |
| Cloudflare Specials | 100021CE | Improve XSS event detection | 2019-04-08 | N/A | N/A |
| Cloudflare Specials | 100021CB | Improve XSS event detection | 2019-04-08 | N/A | N/A |
| Cloudflare Specials | 100021CD | Improve XSS event detection | 2019-04-08 | N/A | N/A |
| Cloudflare Specials | 100021CD2 | Improve XSS event detection | 2019-04-08 | N/A | N/A |
| Cloudflare Specials | 100021CD3 | Improve XSS event detection | 2019-04-08 | N/A | N/A |
| Cloudflare Drupal | D0020BETA | Improve blocking of SA-CORE-2019-003 | 2019-04-08 | Log | Block |
| Cloudflare Drupal | D0017 | Improve blocking of SA-CORE-2019-003 | 2019-04-08 | Log | Block |
| Cloudflare Drupal | D0017 | Improve blocking of SA-CORE-2019-003 | 2019-04-08 | Log | Deleted |
| Cloudflare Drupal | D0018 | Improve blocking of SA-CORE-2019-003 | 2019-04-08 | Log | Deleted |
| Cloudflare Drupal | D0019 | Improve blocking of SA-CORE-2019-003 | 2019-04-08 | Log | Deleted |
| Cloudflare Drupal | D0021 | Improve blocking of SA-CORE-2019-003 | 2019-04-08 | Log | Deleted |
| Cloudflare Specials | 100127 | Improve blocking of SA-CORE-2019-003 | 2019-04-08 | Log | Deleted |
| Cloudflare Specials | 100128 | Improve blocking of SA-CORE-2019-003 | 2019-04-08 | Log | Deleted |
| Cloudflare Specials | 100135A | Improve XSS detection using JavaScript URI | 2019-04-08 | N/A | Block |
| Cloudflare Specials | 100135B | Improve XSS detection using JavaScript URI | 2019-04-08 | N/A | Log |
| Cloudflare Specials | 100135C | Improve XSS detection using JavaScript URI | 2019-04-08 | N/A | Block |
| Cloudflare Specials | 100123A | Improve invalid UTF-8 detection | 2019-04-08 | N/A | Block |
| Cloudflare Specials | 100123B | Improve invalid UTF-8 detection | 2019-04-08 | N/A | Log |
| Cloudflare Specials | 100130 | Executable file upload attempt | 2019-04-08 | Log | Block |
| Cloudflare Specials | 100136A | Improve XSS detection using JavaScript events | 2019-04-01 | N/A | Block |
| Cloudflare Specials | 100136B | Improve XSS detection using JavaScript events | 2019-04-01 | N/A | Block |
| Cloudflare Specials | 100136C | Improve XSS detection using JavaScript events | 2019-04-01 | N/A | Block |
| Cloudflare Specials | 100120BETA2 | Reduce 100120's false positives | 2019-04-01 | Log | Block |
| Cloudflare WordPress | WP0032BETA | Reduce false positives for WP0032 | 2019-04-01 | Log | Block |
| Cloudflare Specials | 100122ARGS | Block use of stream wrappers in all arguments | 2019-04-01 | Log | Block |
| Cloudflare Specials | 100132 | Protection for Apache Tika Command Injection[CVE-2018-1335](https://nvd.nist.gov/vuln/detail/CVE-2018-1335) | 2019-04-01 | Log | Block |
| Cloudflare PHP | PHP100006 | Improve PHP webshell attempt detection. | 2019-04-01 | Log | Block |
| Cloudflare Specials | 100005 | Merge LFI 100005\_BETA into 100005. Mitigates[CVE-2018-9126](https://nvd.nist.gov/vuln/detail/CVE-2018-9126),[CVE-2011-1892](https://nvd.nist.gov/vuln/detail/CVE-2011-1892). | 2019-04-01 | Block | Block |
| Cloudflare Specials | 100005U | Superseded by 100005 | 2019-04-01 | Block | Block |
| Cloudflare Specials | 100005UR | Superseded by 100005 | 2019-04-01 | Block | Block |
| Cloudflare Specials | 100134 | Ruby on Rails File Disclosure[CVE-2019-5418](https://nvd.nist.gov/vuln/detail/CVE-2019-5418) | 2019-04-01 | Log | Block |
| Cloudflare Specials | 100120BETA | Improve 100120's coverage of SQLi | 2019-03-25 | Log | Block |
| Cloudflare Specials | 100130B | Executable file with fake extension upload attempt | 2019-03-25 | Log | Block |
| Cloudflare Specials | 100021CB | Improves XSS event detection using alternate syntax \`, brackets, and parentheses. | 2019-03-18 | Log | Block |
| Cloudflare Specials | 100021A | Improve XSS detection in Referer Header | 2019-03-18 | Challenge | Block |
| Cloudflare Specials | 100030SVG | Improve XSS event detection | 2019-03-18 | Challenge | Block |
| Cloudflare Specials | 100021C | Improve XSS event detection | 2019-03-18 | Block | Block |
| Cloudflare Specials | 100021CE | Improve XSS event detection | 2019-03-18 | Block | Block |
| Cloudflare Specials | 100021CB | Improve XSS event detection | 2019-03-18 | Block | Block |
| Cloudflare Specials | 100122ARGS\_GET | Block use of stream wrappers in GET arguments (RFI/RCE) | 2019-03-18 | Log | Block |
| Cloudflare Specials | 100125 | Block AngularJS Sandbox attacks | 2019-03-18 | Log | Block |
| Cloudflare Specials | 100021D | Improve XSS detection | 2019-03-18 | Challenge | Block |
| Cloudflare WordPress | WP0031 | WordPress RCE -[CVE-2019-8942](https://nvd.nist.gov/vuln/detail/CVE-2019-8942),[CVE-2019-8943](https://nvd.nist.gov/vuln/detail/CVE-2019-8943) | 2019-03-11 | N/A | Block |
| Cloudflare Specials | 100021CB | Improve XSS event detection | 2019-03-11 | Challenge | Block |
| Cloudflare Specials | 100021C | Improve XSS event detection | 2019-03-11 | Block | Block |
| Cloudflare Specials | 100008E | Improve SQLi probing | 2019-03-04 | Block | Block |
| Cloudflare Specials | 100123 | UTF-8 Invalid Characters detection (URL) | 2019-03-04 | Log | Block |
| Cloudflare Specials | 100008E | Improve SQLi probe detection | 2019-02-18 | N/A | Block |
| Cloudflare Specials | 100063\_BETA | Reduce false positives for 100063 | 2019-02-18 | Log | Block |
| Cloudflare Specials | 100021H | Improve XSS | 2019-02-18 | Log | Block |
| Cloudflare Specials | 100021G | Delete XSS rule | 2019-02-18 | Block | Deleted |
| Cloudflare Specials | 100124A | UTF-8 Invalid Characters detection | 2019-02-11 | N/A | Disable |
| Cloudflare Specials | 100124B | UTF-8 Invalid Characters detection | 2019-02-11 | N/A | Disable |
| Cloudflare Specials | 100008 | Moved rule out of BETA | 2019-02-08 | Block | Block |
| Cloudflare Specials | 100011 | Block requests with null bytes | 2019-02-04 | N/A | Disable |
| Cloudflare Specials | 100020 | Blocked SQLi with mysql comments | 2019-02-04 | Log | Block |
| Cloudflare Specials | 100120B | Blocked SQLi with mysql comments | 2019-02-04 | Log | Block |
| Cloudflare Specials | 100120C | Blocked SQLi with mysql comments | 2019-02-04 | N/A | Disable |
| Cloudflare Specials | 100054 | Block[CVE-2017-5638](https://nvd.nist.gov/vuln/detail/CVE-2017-5638)RCE attempts | 2019-02-04 | Log | Block |
| Cloudflare Specials | 100009C | Reduce 100009C false positives | 2019-01-28 | Block | Block |
| Cloudflare Specials | 100007 | Improved RCE detection | 2019-01-28 | Block | Block |
| Cloudflare PHP | PHP100012 | Detect[CVE-2017-9841](https://nvd.nist.gov/vuln/detail/CVE-2017-9841) | 2019-01-28 | N/A | Block |
| Cloudflare Specials | 100112B | Block requests with duplicated User-Agent headers | 2019-01-21 | N/A | Disable |
| Cloudflare Specials | 100009J | Reduce 100009J false positives | 2019-01-21 | Block | Block |
| Cloudflare Specials | 100114 | Improved XSS probing detection | 2019-01-21 | Log | Block |
| Cloudflare Specials | 100005 | Improved LFI detection | 2019-01-21 | Log | Block |
| Cloudflare Drupal | D0015 | Drupal SA-CORE-2019-002 vulnerability | Emergency, 2019-01-17 | N/A | Block |
| Cloudflare Drupal | D0016 | Drupal SA-CORE-2019-002 vulnerability | Emergency, 2019-01-17 | N/A | Log |
| Cloudflare PHP | PHP100011 | Improved PHP code injection detection in URI and headers | 2019-01-14 | Log | Block |
| Cloudflare Specials | 100121ARGS\_GET | Use of multiple percent-encoding level in URI arguments | 2019-01-07 | N/A | Disable |
| Cloudflare Specials | 100121URI | Use of multiple percent-encoding level in URI | 2019-01-07 | N/A | Disable |
| Cloudflare Specials | 100021CD3 | XSS reflection with JavaScript events | 2019-01-02 | N/A | Disable |
| Cloudflare Specials | 100068B | Improve SQLi detection | 2019-01-02 | Log | Block |
| Cloudflare Specials | 100021\_BETA | Improve XSS detection | 2019-01-02 | Log | Challenge |
