---
title: Example values · Cloudflare Style Guide
description: As described in RFC 2606 and RFC 6761, a number of domains such as
  example.com and example.org are maintained for documentation purposes.
  Sometimes you also need to differentiate between a customer domain and your
  own application domain, so Cloudflare has also registered some domains for you
  to use.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/formatting/example-values/
  md: https://developers.cloudflare.com/style-guide/formatting/example-values/index.md
---

## DNS Domains

As described in [RFC 2606](https://www.iana.org/go/rfc2606) and [RFC 6761](https://www.iana.org/go/rfc6761), a number of domains such as example.com and example.org are maintained for documentation purposes. Sometimes you also need to differentiate between a customer domain and your own application domain, so Cloudflare has also registered some domains for you to use.

Examples:

* `example.com`
* `example.org`
* `myappexample.com`
* `mycustomerexample.com`

IANA also maintains more example domains [documented here](https://www.iana.org/domains/reserved).

## IPv4 ranges

According to the Internet Engineering Task Force (IETF), there are specific [IPv4 ranges used for documentation](https://datatracker.ietf.org/doc/rfc5737/):

Examples:

* `192.0.2.0/24`.
* `198.51.100.0/24`.
* `203.0.113.0/24`.

These IP addresses are reserved and will not take anyone to live origins.
