---
title: Design guide · Cloudflare Style Guide
description: Help users understand how to plan and design a solution using
  Cloudflare. Typically design guides are a subset of a reference architecture.
lastUpdated: 2025-06-24T21:05:23.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/design-guide/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/design-guide/index.md
---

## Purpose

Help users understand how to plan and design a solution using Cloudflare. Typically [design guides](https://developers.cloudflare.com/reference-architecture/design-guides/) are a subset of a [reference architecture](https://developers.cloudflare.com/reference-architecture/).

Disambiguation

This page describes the content strategy for a design guide. For help with Cloudflare products, refer to [Design guides](https://developers.cloudflare.com/reference-architecture/design-guides/).

## Tone

instructional, straightforward

## content\_type

```yaml
pcx_content_type: design-guide
```

For more details, refer to [`pcx_content_type`](https://developers.cloudflare.com/style-guide/frontmatter/custom-properties/#pcx_content_type).

## Examples

[Securely deliver applications with Cloudflare](https://developers.cloudflare.com/reference-architecture/design-guides/secure-application-delivery/)

## Structure

### Required components

[**Title**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/titles/): Short verb phrase in second-person imperative. Do not use gerund phrases.

[**Introduction**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/introduction/): Two to three paragraphs describing the subject matter.

[**Intended audience**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/intended-audience/): Summary of who the content is aimed at and what users will learn.

### Optional components

[**Notes/warnings**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/notes-tips-warnings/)

[**Examples**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/examples/)

[**Diagrams**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/diagrams/)

**Screenshots**

[**Related links**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/links/): Bulleted list of links to associated resources.

## Template

```plaintext
---
title: "Example design guide"
pcx_content_type: design-guide
weight:
meta:
  title: "Design guide: An example"
---


# Design guide title


## Introduction
Provide context to what this guide is going to cover. Ensure you describe the end state of the solution this guide will detail.


### Who is this for?
This reference architecture is designed for IT or security professionals with some responsibility over or familiarity with their organization’s existing infrastructure. It is useful to have some experience with technologies important to securing hybrid work, including identity providers (IdPs), user directories, single sign on (SSO), endpoint security or management (EPP, XDR, UEM, MDM), firewalls, routers, and point solutions like packet or content inspection hardware, threat prevention, and data loss prevention technologies.


## Heading 1
### Subheading 1


## Heading 2
### Subheading 2


## Heading 3
### Subheading 4


## Summary
```
