---
title: Cloudflare Spectrum · Cloudflare Spectrum docs
description: Spectrum allows you to route MQTT, email, file transfer, version
  control, games, and more over TCP or UDP through Cloudflare to mask the origin
  and protect it from DDoS attacks.
lastUpdated: 2025-07-31T21:09:55.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/spectrum/
  md: https://developers.cloudflare.com/spectrum/index.md
---

Spectrum provides security and acceleration for any [TCP](https://www.cloudflare.com/learning/ddos/glossary/tcp-ip/) or [UDP](https://www.cloudflare.com/learning/ddos/glossary/user-datagram-protocol-udp/) based application.

Available on Paid plans

Spectrum allows you to route MQTT, email, file transfer, version control, games, and more over TCP or UDP through Cloudflare to mask the origin and protect it from [DDoS attacks](https://www.cloudflare.com/learning/ddos/what-is-a-ddos-attack/).

***

## Features

### Enable Proxy protocol

Use a proxy protocol for Cloudflare to pass on the client IP to your service.

[Use Enable Proxy protocol](https://developers.cloudflare.com/spectrum/how-to/enable-proxy-protocol/)

### DDoS Protection for Spectrum

Learn more about what L3/4 DDoS Protection is included as part of the Spectrum service.

[Use DDoS Protection for Spectrum](https://developers.cloudflare.com/spectrum/about/ddos-for-spectrum/)

***

## Related products

**[DDoS Protection](https://developers.cloudflare.com/ddos-protection/)**

Cloudflare DDoS protection secures websites, applications, and entire networks while ensuring the performance of legitimate traffic is not compromised.

**[BYOIP](https://developers.cloudflare.com/byoip/)**

Get Cloudflare's security and performance while using your own IPs. With Bring Your Own IP (BYOIP), Cloudflare announces your IPs in all our locations.

**[Load Balancing](https://developers.cloudflare.com/load-balancing/)**

Cloudflare Load Balancing distributes traffic across your endpoints, which reduces endpoint strain and latency and improves the experience for end users.

**[DNS](https://developers.cloudflare.com/dns/)**

Cloudflare's global DNS platform provides speed and resilience. DNS customers also benefit from free DNSSEC, and protection against route leaks and hijacking.

***

## More resources

[Plans](https://www.cloudflare.com/plans/)

Compare available Cloudflare plans.
