---
title: Limits · Cloudflare Sandbox SDK docs
description: Since the Sandbox SDK is built on top of the Containers platform,
  it shares the same underlying platform characteristics. Refer to these pages
  to understand how pricing and limits work for your sandbox deployments.
lastUpdated: 2025-10-15T17:28:03.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/sandbox/platform/limits/
  md: https://developers.cloudflare.com/sandbox/platform/limits/index.md
---

Since the Sandbox SDK is built on top of the [Containers](https://developers.cloudflare.com/containers/) platform, it shares the same underlying platform characteristics. Refer to these pages to understand how pricing and limits work for your sandbox deployments.

## Container Limits

Refer to [Containers limits](https://developers.cloudflare.com/containers/platform-details/limits/) for complete details on:

* Memory, vCPU, and disk limits for concurrent container instances
* Instance types and their resource allocations
* Image size and storage limits

## Best Practices

To work within these limits:

* **Right-size your instances** - Choose the appropriate [instance type](https://developers.cloudflare.com/containers/platform-details/limits/#instance-types) based on your workload requirements
* **Clean up unused sandboxes** - Terminate sandbox sessions when they're no longer needed to free up resources
* **Optimize images** - Keep your [custom Dockerfiles](https://developers.cloudflare.com/sandbox/configuration/dockerfile/) lean to reduce image size
