---
title: cf.llm.prompt.unsafe_topic_categories · Cloudflare Ruleset Engine docs
description: Array of string values with the type of unsafe topics detected in
  the LLM prompt.
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.unsafe_topic_categories/
  md: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.unsafe_topic_categories/index.md
---

# cf.llm.prompt.unsafe\_topic\_categories

`cf.llm.prompt.unsafe_topic_categories` Array\<String>

Array of string values with the type of unsafe topics detected in the LLM prompt.

The possible values are the following:

| Value | Category name | Description |
| - | - | - |
| `S1` | Violent Crimes | Violent crimes against people or animals. |
| `S2` | Non-Violent Crimes | Non-violent offenses such as fraud, theft, drug creation, or hacking. |
| `S3` | Sex-Related Crimes | Sex-related crimes, including trafficking, assault, and harassment. |
| `S4` | Child Sexual Exploitation | Sexual exploitation of children. |
| `S5` | Defamation | False statements that are likely to damage a living person's reputation. |
| `S6` | Specialized Advice | Specialized financial, medical, or legal advice, or misrepresent dangerous things as safe. |
| `S7` | Privacy | Sensitive, nonpublic personal information that could endanger an individual. |
| `S8` | Intellectual Property | Violate a third party's intellectual property rights. |
| `S9` | Indiscriminate Weapons | Creation of indiscriminate weapons like chemical, biological, or nuclear arms. |
| `S10` | Hate | Demean or dehumanize people based on their race, religion, sexual orientation, or other personal characteristics. |
| `S11` | Suicide & Self-Harm | Encourage or endorse suicide, self-injury, or disordered eating. |
| `S12` | Sexual Content | Erotic content. |
| `S13` | Elections | False information about the time, place, or manner of voting in elections. |

Requires a Cloudflare Enterprise plan. You must also enable [Firewall for AI](https://developers.cloudflare.com/waf/detections/firewall-for-ai/).

Example usage:

```txt
# Matches requests where an unsafe topic categorized as "S2" (Non-Violent Crimes) or "S10" (Hate) was detected in the LLM prompt:
(cf.llm.prompt.unsafe_topic_detected and any(cf.llm.prompt.unsafe_topic_categories[*] in {"S2" "S10"}))
```

Categories:

* Request
