---
title: Release notes · Cloudflare Radar docs
description: Review recent changes to Cloudflare Radar.
lastUpdated: 2025-05-02T13:54:11.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/radar/release-notes/
  md: https://developers.cloudflare.com/radar/release-notes/index.md
---

[Subscribe to RSS](https://developers.cloudflare.com/radar/release-notes/index.xml)

## 2025-11-24

**Add HTTP origins insights**

* Added new [`Origins`](https://developers.cloudflare.com/api/resources/radar/subresources/origins/) API.
* Extended [`Annotations`](https://developers.cloudflare.com/api/resources/radar/subresources/annotations/) and [`Traffic Anomalies`](https://developers.cloudflare.com/api/resources/radar/subresources/traffic_anomalies/) APIs to support origin outages and anomalies.

## 2025-10-27

**Add TLD insights**

* Added new dimensions `tld` and `tld_dns_magnitude` to the [DNS](https://developers.cloudflare.com/api/resources/radar/subresources/dns/) API.
* Added new endpoints [`/tlds`](https://developers.cloudflare.com/api/resources/radar/subresources/tlds/methods/list/) and [`/tlds/{tld}`](https://developers.cloudflare.com/api/resources/radar/subresources/tlds/methods/get/).

## 2025-10-09

**Add CT log activity statistics**

* Added new CT log activity stats to the [Get Certificate Log Details](https://developers.cloudflare.com/api/resources/radar/subresources/ct/subresources/logs/methods/get/) API response.

## 2025-10-06

**Add PQ encryption browser support check**

* Added a [post-quantum encryption browser support check](https://radar.cloudflare.com/adoption-and-usage#browser-support) to the PQ encryption card in the Adoption & Usage section.

## 2025-09-29

**Add geolocation, ADM1 dimension to HTTP endpoints, and NetFlows endpoints**

* Added new [geolocation endpoints](https://developers.cloudflare.com/api/resources/radar/subresources/geolocations/).
* Added new ADM1 dimension to [`HTTP`](https://developers.cloudflare.com/api/resources/radar/subresources/http/) `summary` and `timeseries_groups` endpoints.
* Added new [`NetFlows`](https://developers.cloudflare.com/api/resources/radar/subresources/netflows/) summary by dimension endpoint [summary\_v2](https://developers.cloudflare.com/api/resources/radar/subresources/netflows/methods/summary_v2/).
* Added new `geoId` filter to all [`HTTP`](https://developers.cloudflare.com/api/resources/radar/subresources/http/) and [`NetFlows`](https://developers.cloudflare.com/api/resources/radar/subresources/netflows/) endpoints.

## 2025-09-22

**Add IRR AS-SET membership lookup endpoint**

* Added IRR AS-SET membership lookup endpoint
  * [`/entities/asns/{asn}/as_set`](https://developers.cloudflare.com/api/resources/radar/subresources/entities/subresources/asns/methods/as_set/)

## 2025-08-27

**Add industry and vertical to AI Bots and Web Crawlers, and bot kind to Bots**

* Added vertical and industry dimensions/filters to:

  * [`/ai/bots/summary/{dimension}`](https://developers.cloudflare.com/api/resources/radar/subresources/ai/subresources/timeseries_groups/methods/summary/)
  * [`/ai/bots/timeseries_groups/{dimension}`](https://developers.cloudflare.com/api/resources/radar/subresources/ai/subresources/timeseries_groups/methods/timeseries_groups/)
  * [`/bots/crawlers/summary/{dimension}`](https://developers.cloudflare.com/api/resources/radar/subresources/bots/subresources/web_crawlers/methods/summary/)
  * [`/bots/crawlers/timeseries_groups/{dimension}`](https://developers.cloudflare.com/api/resources/radar/subresources/bots/subresources/web_crawlers/methods/timeseries_groups/)

* Added bot kind dimension/filter to:

  * [`/bots/summary/{dimension}`](https://developers.cloudflare.com/api/resources/radar/subresources/bots/methods/summary/)
  * [`/bots/timeseries_groups/{dimension}`](https://developers.cloudflare.com/api/resources/radar/subresources/bots/methods/timeseries_groups/)

* Added new `botKind` filter to:
  * [`/bots/timeseries`](https://developers.cloudflare.com/api/resources/radar/subresources/bots/methods/timeseries/)

* Added new `kind` property/filter to:

  * [`/bots`](https://developers.cloudflare.com/api/resources/radar/subresources/bots/methods/list/)
  * [`/bots/{bot_slug}`](https://developers.cloudflare.com/api/resources/radar/subresources/bots/methods/get/)

## 2025-08-14

**Add AI Bots crawl purpose**

* Added AI Bots crawl purpose dimension and filter to [summary](https://developers.cloudflare.com/api/resources/radar/subresources/ai/subresources/timeseries_groups/methods/summary/) and [timeseries\_groups](https://developers.cloudflare.com/api/resources/radar/subresources/ai/subresources/timeseries_groups/methods/timeseries_groups/) endpoints.

## 2025-08-06

**Add Certificate Transparency (CT) endpoints**

* Added [CT endpoints](https://developers.cloudflare.com/api/resources/radar/subresources/ct/).

## 2025-07-01

**Add Bots and Web Crawlers endpoints**

* Added new [bots endpoints](https://developers.cloudflare.com/api/resources/radar/subresources/bots/), replacing the deprecated verified bots endpoints. Use the following replacements:

  * `/verified_bots/top/bots` → `/bots/summary/bot`
  * `/verified_bots/top/categories` → `/bots/summary/bot_category`

* Added [web crawlers endpoints](https://developers.cloudflare.com/api/resources/radar/subresources/bots/subresources/web_crawlers/).

## 2025-03-20

**Endpoint deprecations and new BGP real-time routes endpoint**

* Deprecated endpoints for improved consistency (switch to the following):

  * `/attacks/layer3/top/industry` → [`/attacks/layer3/summary/industry`](https://developers.cloudflare.com/api/resources/radar/subresources/attacks/subresources/layer3/subresources/summary/methods/industry/)
  * `/attacks/layer3/top/vertical` → [`/attacks/layer3/summary/vertical`](https://developers.cloudflare.com/api/resources/radar/subresources/attacks/subresources/layer3/subresources/summary/methods/vertical/)
  * `/attacks/layer7/top/industry` → [`/attacks/layer7/summary/industry`](https://developers.cloudflare.com/api/resources/radar/subresources/attacks/subresources/layer7/subresources/summary/methods/industry/)
  * `/attacks/layer7/top/vertical` → [`/attacks/layer7/summary/vertical`](https://developers.cloudflare.com/api/resources/radar/subresources/attacks/subresources/layer7/subresources/summary/methods/vertical/)

* Added the [BGP real-time routes endpoint](https://developers.cloudflare.com/api/resources/radar/subresources/bgp/subresources/routes/methods/realtime/).

## 2025-03-18

**Add leaked credential checks endpoints**

* Added [leaked credential checks endpoints](https://developers.cloudflare.com/api/resources/radar/subresources/leaked_credentials/).

## 2025-02-27

**Add DNS endpoints**

* Added [DNS endpoints](https://developers.cloudflare.com/api/resources/radar/subresources/dns/).

## 2025-02-04

**Add Internet services ranking, robots.txt, and AI inference endpoints**

* Added [Internet services ranking endpoints](https://developers.cloudflare.com/api/resources/radar/subresources/ranking/subresources/internet_services/).
* Added [robots.txt endpoints](https://developers.cloudflare.com/api/resources/radar/subresources/robots_txt/).
* Added [AI inference endpoints](https://developers.cloudflare.com/api/resources/radar/subresources/ai/subresources/inference/).

## 2024-06-27

**Change TCP connection tampering API endpoints to TCP Resets Timeouts**

* Changed the connection tampering summary and timeseries API endpoints to TCP resets timeouts [summary](https://developers.cloudflare.com/api/resources/radar/subresources/tcp_resets_timeouts/methods/summary/) and [timeseries](https://developers.cloudflare.com/api/resources/radar/subresources/tcp_resets_timeouts/methods/timeseries_groups/), respectively.

## 2023-11-27

**Add more meta information's**

* Added meta.lastUpdated to all summaries and top endpoints (timeseries and timeseriesGroups already had this).
* Fixed meta.dateRange to return date ranges for all requested series.

## 2023-11-16

**Add new layer 3 endpoints and layer 7 dimensions**

* Added layer 3 [top origin locations](https://developers.cloudflare.com/api/resources/radar/subresources/attacks/subresources/layer3/subresources/top/subresources/locations/methods/origin/) and [top target location](https://developers.cloudflare.com/api/resources/radar/subresources/attacks/subresources/layer3/subresources/top/subresources/locations/methods/target/).
* Added layer 7 Summaries by `http_method`, `http_version`, `ip_version`, `managed_rules`, `mitigation_product`.
* Added layer 7 Timeseries Groups by `http_method`, `http_version`, `ip_version`, `managed_rules`, `mitigation_product`, `industry`, `vertical`.
* Added layer 7 Top by `industry`, `vertical`.
* Deprecated layer 7 timeseries groups without dimension.
  * To continue getting this data, switch to the new [timeseries group by mitigation\_product](https://developers.cloudflare.com/api/resources/radar/subresources/attacks/subresources/layer7/subresources/timeseries_groups/methods/mitigation_product/) endpoint.
* Deprecated layer 7 summary without dimension.
  * To continue getting this data, switch to the new [summary by mitigation\_product](https://developers.cloudflare.com/api/resources/radar/subresources/attacks/subresources/layer7/subresources/summary/methods/mitigation_product/) endpoint.
* Added new [Error codes](https://developers.cloudflare.com/radar/get-started/error-codes/).

## 2023-10-31

**Add new layer 3 direction parameter**

* Added a `direction` parameter to all layer 3 endpoints. Use together with `location` parameter to filter by origin or target location [timeseries groups](https://developers.cloudflare.com/api/resources/radar/subresources/attacks/subresources/layer3/subresources/timeseries_groups/methods/vector/).

## 2023-09-08

**Add Connection Tampering endpoints**

* Added Connection Tampering [summary](https://developers.cloudflare.com/api/resources/radar/subresources/tcp_resets_timeouts/methods/summary/) and [timeseries](https://developers.cloudflare.com/api/resources/radar/subresources/tcp_resets_timeouts/methods/timeseries_groups/) endpoints.

## 2023-08-14

**Deprecate old layer 3 dataset**

* Added Regional Internet Registry (see field `source` in response) to [get asn by id](https://developers.cloudflare.com/api/resources/radar/subresources/entities/subresources/asns/methods/get/) and [get asn by ip](https://developers.cloudflare.com/api/resources/radar/subresources/entities/subresources/asns/methods/ip/) endpoints.
* Stopped collecting data in the old layer 3 data source.
* Updated layer 3 [timeseries](https://developers.cloudflare.com/api/resources/radar/subresources/attacks/subresources/layer3/methods/timeseries/) endpoint to start using the new layer 3 data source by default, fetching the old data source now requires sending the parameter `metric=bytes_old`.
* Deprecated layer 3 summary endpoint, this will stop receiving data after 2023-08-14.
  * To continue getting this data, switch to the new [timeseries group protocol](https://developers.cloudflare.com/api/resources/radar/subresources/attacks/subresources/layer3/subresources/summary/methods/protocol/) endpoint.
* Deprecated layer 3 timeseries groups endpoint, this will stop receiving data after 2023-08-14.
  * To continue getting this data, switch to the new [timeseries group protocol](https://developers.cloudflare.com/api/resources/radar/subresources/attacks/subresources/layer3/subresources/timeseries_groups/methods/protocol/) endpoint.

## 2023-07-31

**Fix HTTP timeseries endpoint URLs**

* Updated HTTP `timeseries` endpoints URLs to [`timeseries_groups`](https://developers.cloudflare.com/api/resources/radar/subresources/http/subresources/timeseries_groups/) due to consistency. Old timeseries endpoints are still available, but will soon be removed.

## 2023-07-20

**Add URL Scanner endpoints**

* Added [URL Scanner endpoints](https://developers.cloudflare.com/api/resources/url_scanner/). For more information, refer to [URL Scanner](https://developers.cloudflare.com/radar/investigate/url-scanner/).

## 2023-06-20

**Add Internet quality endpoints**

* Added [Internet quality endpoints](https://developers.cloudflare.com/api/resources/radar/subresources/quality/).

## 2023-06-07

**Add BGP stats, pfx2as and moas endpoints**

* Added BGP [stats](https://developers.cloudflare.com/api/resources/radar/subresources/bgp/subresources/routes/methods/stats/), [pfx2as](https://developers.cloudflare.com/api/resources/radar/subresources/bgp/subresources/routes/methods/pfx2as/) and [moas](https://developers.cloudflare.com/api/resources/radar/subresources/bgp/subresources/routes/methods/moas/) endpoints.

## 2023-05-10

**Added \`IOS\` as an option for the OS parameter in all HTTP**

* Added `IOS` as an option for the OS parameter in all HTTP endpoints ([example](https://developers.cloudflare.com/api/resources/radar/subresources/http/subresources/summary/methods/bot_class/)).

## 2023-03-20

**Add AS112 and email endpoints**

* Added [AS112 endpoints](https://developers.cloudflare.com/api/resources/radar/subresources/as112/).
* Added [email endpoints](https://developers.cloudflare.com/api/resources/radar/subresources/email/).

## 2023-01-23

**Updated IPv6 calculation method**

* IPv6 percentage started to be calculated as (IPv6 requests / requests for dual-stacked content), where as before it was calculated as (IPv6 requests / IPv4+IPv6 requests).

## 2023-01-11

**Add new layer 3 dataset**

* Added new layer 3 data source and related endpoints.
* Updated layer 3 [timeseries](https://developers.cloudflare.com/api/resources/radar/subresources/attacks/subresources/layer3/methods/timeseries/) endpoint to support fetching both current and new data sources. For retro-compatibility reasons, fetching the new data source requires sending the parameter `metric=bytes` else the current data source will be returned.
* Deprecated old layer 3 endpoints timeseries\_groups and summary. Users should upgrade to newer endpoints.
