---
title: Cloudflare HTTP headers · Cloudflare Fundamentals docs
description: Cloudflare passes all HTTP request headers to your origin web
  server and adds additional headers as specified below.
lastUpdated: 2025-10-28T15:36:36.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/reference/http-headers/
  md: https://developers.cloudflare.com/fundamentals/reference/http-headers/index.md
---

## Request headers

Cloudflare passes all HTTP request headers to your origin web server and adds additional headers as specified below.

Note

Cloudflare may remove HTTP request headers with names considered invalid [according to NGINX](https://nginx.org/en/docs/http/ngx_http_core_module.html#ignore_invalid_headers) — for example, header names containing a `.` (dot) character.

### Accept-Encoding

For incoming requests, the value of this header will always be set to `accept-encoding: br, gzip`. If the client set a different value, such as `accept-encoding: deflate`, it will be overwritten and the original value will be available in `request.cf.clientAcceptEncoding`.

### CF-Connecting-IP

`CF-Connecting-IP` provides the client IP address connecting to Cloudflare to the origin web server. This header will only be sent on the traffic from Cloudflare's edge to your origin web server.

For guidance on logging your visitor's original IP address, refer to [Restoring original visitor IPs](https://developers.cloudflare.com/support/troubleshooting/restoring-visitor-ips/restoring-original-visitor-ips/).

Alternatively, if you do not wish to receive the `CF-Connecting-IP` header or any HTTP header that may contain the visitor's IP address, [enable the **Remove visitor IP headers** Managed Transform](https://developers.cloudflare.com/rules/transform/managed-transforms/configure/).

#### CF-Connecting-IP in Worker subrequests

In same-zone Worker subrequests, the value of `CF-Connecting-IP` reflects the value of `x-real-ip` (the client's IP). `x-real-ip` can be altered by the user in their Worker script.

In cross-zone subrequests from one Cloudflare zone to another Cloudflare zone, the `CF-Connecting-IP` value will be set to the Worker client IP address `'2a06:98c0:3600::103'` for security reasons.

For Worker subrequests destined for a non-Cloudflare customer zone, the `CF-Connecting-IP` and `x-real-ip` headers will both reflect the client's IP address, with only the `x-real-ip` header able to be altered.

When no Worker subrequest is triggered, `cf-connecting-ip` reflects the client's IP address and the `x-real-ip` header is stripped.

### CF-Connecting-IPv6

Cloudflare provides [free IPv6 support](https://developers.cloudflare.com/network/ipv6-compatibility/) to all domains without requiring additional configuration or hardware. To support migrating to IPv6, Cloudflare's [Pseudo IPv4](https://developers.cloudflare.com/network/pseudo-ipv4/) provides an IPv6 to IPv4 translation service for all Cloudflare domains.

If **Pseudo IPv4** is set to `Overwrite Headers` - Cloudflare overwrites the existing `Cf-Connecting-IP` and `X-Forwarded-For` headers with a pseudo IPv4 address while preserving the real IPv6 address in `CF-Connecting-IPv6` header.



### CF-EW-Via

This header is used for loop detection, similar to the `CDN-Loop` [header](https://blog.cloudflare.com/preventing-request-loops-using-cdn-loop/).

### CF-Pseudo-IPv4

If [Pseudo IPv4](https://developers.cloudflare.com/network/pseudo-ipv4/) is set to `Add Header` - Cloudflare automatically adds the `CF-Pseudo-IPv4` header with a Class E IPv4 address hashed from the original IPv6 address.

### True-Client-IP (Enterprise plan only)

`True-Client-IP` provides the original client IP address to the origin web server. `True-Client-IP` is only available on an Enterprise plan. In the example below, `203.0.113.1` is the original visitor IP address. For example: `True-Client-IP: 203.0.113.1`

There is no difference between the `True-Client-IP` and `CF-Connecting-IP` headers besides the name of the header. Some Enterprise customers with legacy devices need `True-Client-IP` to avoid updating firewalls or load-balancers to read a custom header name.

To add a `True-Client-IP` HTTP header to requests, [enable the **Add "True-Client-IP" header** Managed Transform](https://developers.cloudflare.com/rules/transform/managed-transforms/configure/).

Alternatively, if you do not wish to receive the `True-Client-IP` header or any HTTP header that may contain the visitor's IP address, [enable the **Remove visitor IP headers** Managed Transform](https://developers.cloudflare.com/rules/transform/managed-transforms/configure/).

Warning

If you are using Cloudflare in a stacked CDN and authenticating HTTP requests based on the IP address value in the `True-Client-IP` header, you must add a `True-Client-IP` header to your requests. If you do not add this header, its value can be spoofed to any value.

### X-Forwarded-For

`X-Forwarded-For` maintains proxy server and original visitor IP addresses. If there was no existing `X-Forwarded-For`header in the request sent to Cloudflare, `X-Forwarded-For` has an identical value to the `CF-Connecting-IP` header.

For example, if the original visitor IP address is `203.0.113.1` and the request sent to Cloudflare does not contain an `X-Forwarded-For` header, then Cloudflare will send `X-Forwarded-For: 203.0.113.1` to the origin.

If, on the other hand, an `X-Forwarded-For` header was already present in the request to Cloudflare, Cloudflare will append the IP address of the HTTP proxy connecting to Cloudflare to the header. For example, if the original visitor IP address is `203.0.113.1` and a request is proxied through two proxies: proxy A with an IP address of `198.51.100.101` and proxy B with an IP address of `198.51.100.102` before being proxied to Cloudflare, then Cloudflare will send `X-Forwarded-For: 203.0.113.1,198.51.100.101,198.51.100.102` to the origin. Proxy A will append the original visitor's IP address (`203.0.113.1`) to `X-Forwarded-For` before proxying the request to proxy B which, in turn, will append Proxy A's IP address (`198.51.100.101`) to `X-Forwarded-For` before proxying the request to Cloudflare. And finally, Cloudflare will append proxy B's IP address (`198.51.100.102`) to `X-Forwarded-For` before proxying the request to the origin.

If you do not wish to receive the visitor's IP address in the `X-Forwarded-For` header, or any HTTP header that may contain the visitor's IP address, [enable the **Remove visitor IP headers** Managed Transform](https://developers.cloudflare.com/rules/transform/managed-transforms/configure/).

Note

To restore the original visitor IP address at your origin web server, Cloudflare recommends that your logs or applications look at `CF-Connecting-IP` or `True-Client-IP` instead of `X-Forwarded-For`. `CF-Connecting-IP` and `True-Client-IP` both have a consistent format containing only one IP address.

### X-Forwarded-Proto

`X-Forwarded-Proto` is used to identify the protocol (HTTP or HTTPS) that a visitor used to connect to Cloudflare. By default, the protocol used is `https`, unless the visitor selected a different [encryption mode](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/#custom-ssltls).

For incoming requests, the value of this header will be set to the protocol the client used (`http` or `https`). If the client set a different value, it will be overwritten.

### Cf-Ray

The `Cf-Ray` header (otherwise known as a [Ray ID](https://developers.cloudflare.com/fundamentals/reference/cloudflare-ray-id/)) is a hashed value that encodes information about the data center and the visitor's request. For example: `Cf-Ray: 230b030023ae2822-SJC`.

The Cf-Ray header identifies the data center processing the request when displayed as a response header. This is represented by a three-letter code corresponding to the data center's location.

The Cf-Ray header is also sent to upstream origins and may be modified to reflect the connecting data center. This occurs when a request is routed through [Argo Smart Routing](https://developers.cloudflare.com/argo-smart-routing/) or [Argo Tiered Caching](https://developers.cloudflare.com/cache/how-to/tiered-cache/). In such cases, the three-letter code in the Cf-Ray header will indicate the data center connecting to the origin, not the ingress data center.

Add the [`Cf-Ray` header to your origin web server logs](https://developers.cloudflare.com/support/troubleshooting/general-troubleshooting/gathering-information-for-troubleshooting-sites/#add-the-cf-ray-header-to-your-logs) to match requests proxied to Cloudflare to requests in your server logs.

Enterprise customers can see all requests via [Cloudflare Logs](https://developers.cloudflare.com/logs/), including data related to the ingress data center.

### CF-IPCountry

The `CF-IPCountry` header contains a two-character country code of the originating visitor's country.

Besides the [ISO-3166-1 alpha-2 codes](https://www.iso.org/iso-3166-country-codes.html), Cloudflare uses the following special country codes:

* `XX` - Used for clients without country code data.
* `T1` - Used for clients using the Tor network.

To add this header to requests, along with other HTTP headers with location information for the visitor's IP address, [enable the **Add visitor location headers** Managed Transform](https://developers.cloudflare.com/rules/transform/managed-transforms/configure/).

Note

The `CF-IPCountry` header is removed from requests made from a Worker to an origin that is not proxied behind Cloudflare.

### CF-Visitor

Currently, this header is a JSON object, containing only one key called `scheme`. The header will be either HTTP or HTTPS, and it is only relevant if you need to enable Flexible SSL in your Cloudflare settings. For example: `CF-Visitor: { \"scheme\":\"https\"}`.

### CDN-Loop

`CDN-Loop` allows Cloudflare to specify how many times a request can enter Cloudflare's network before it is blocked as a looping request. For example: `CDN-Loop: cloudflare`.

### CF-Connecting-O2O

If [SSL for SaaS](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/) is used for [the SaaS provider-owned zone](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/saas-customers/how-it-works/), a HTTP header will be set to `cf-connecting-o2o: 1`.

### CF-Worker

The `CF-Worker` request header is added to an edge Worker subrequest that identifies the host that spawned the subrequest. For example: `CF-Worker: example.com`.

You can add `CF-Worker` header on server logs similar to the way you add the [`CF-RAY`](https://developers.cloudflare.com/support/troubleshooting/general-troubleshooting/gathering-information-for-troubleshooting-sites/#add-the-cf-ray-header-to-your-logs) header. To do that, add `$http_cf_worker` in the log format file: `log_format cf_custom "CF-Worker:$http_cf_worker"'`

`CF-Worker` is added to all Worker subrequests sent via `fetch()`. It is set to the name of the zone which owns the Worker making the subrequest. For example, a Worker script on route for `foo.example.com/*` from `example.com` will have all subrequests with the header:

```txt
CF-Worker: example.com
```

The intended purpose of this header is to provide a means for recipients (for example, origins, load balancers, other Workers) to recognize, filter, and route traffic generated by Workers on specific zones.

Note

When configuring WAF custom rules, do not match on this header. These rules are applied before Cloudflare adds the `CF-Worker` header. Instead, use the [`cf.worker.upstream_zone`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.worker.upstream_zone/) field, which contains the same value and exists for the same purpose.

To block a specific Worker, add a `Block` action triggered by the expression `cf.worker.upstream_zone eq "example.com"`.

To block all Worker subrequests except those from your own zone's Worker, add a `Block` action triggered by the expression `not (cf.worker.upstream_zone in {"" "customer-zone.com"})`.

### Connection

For incoming requests, the value of this header will always be set to `Keep-Alive`. If the client set a different value, such as `close`, it will be overwritten. Note that is also the case when the client uses HTTP/2 or HTTP/3 to connect.

### Considerations for Spectrum

When using Spectrum with a TCP application, these headers are not visible at the origin as they are HTTP headers. If you wish to utilize these in your application, there are two options:

* Use an HTTP or HTTPS Spectrum app instead of TCP
* Use the [Proxy Protocol feature](https://developers.cloudflare.com/spectrum/how-to/enable-proxy-protocol/)

## Response headers

Cloudflare will remove some HTTP headers from the response sent back to the visitor and add some Cloudflare-specific HTTP headers.

### Removed response headers

Cloudflare passes all HTTP headers in the response from the origin server back to the visitor with the exception of the following headers:

* `X-Accel-Buffering`
* `X-Accel-Charset`
* `X-Accel-Limit-Rate`
* `X-Accel-Redirect`
* `Alt-Svc`

### Added response headers

Cloudflare adds the HTTP headers specified below to the response sent to the visitor.

#### Cf-Ray

The `Cf-Ray` value returned to the visitor will be the same `Cf-Ray` value that was sent to the origin server.

#### Cf-Cache-Status

A list of all possible `Cf-Cache-Status` values is contained in [Cloudflare cache responses](https://developers.cloudflare.com/cache/concepts/cache-responses/).
