---
title: DNS Firewall · Cloudflare DNS docs
description: Cloudflare DNS Firewall proxies all DNS queries to your nameservers
  through Cloudflare’s global network. This action protects upstream nameservers
  from DDoS attacks and reduces load by caching DNS responses.
lastUpdated: 2025-02-11T10:50:09.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/dns-firewall/
  md: https://developers.cloudflare.com/dns/dns-firewall/index.md
---

Speed up and protect entire authoritative nameservers

Enterprise-only paid add-on

Cloudflare DNS Firewall proxies all DNS queries to your nameservers through Cloudflare’s global network. This action protects upstream nameservers from DDoS attacks and reduces load by caching DNS responses.

![Diagram showing protection provided by DNS Firewall. For more details, read further.](https://developers.cloudflare.com/_astro/dns-firewall-overview.DCpibQR6_Ca8UJ.webp)

DNS Firewall is for customers who need to speed up and protect entire authoritative nameservers. If you need to speed up and protect individual zones, refer to Cloudflare DNS [Setups](https://developers.cloudflare.com/dns/zone-setups/).

***

## How DNS Firewall works

When a DNS query for your domain takes place:

1. Queries go to the Cloudflare data center that is closest to the website visitor. This is determined by the location of the DNS resolver.
2. Cloudflare tries to return a DNS response from cache.
3. If the response is not available in cache, Cloudflare queries the upstream authoritative nameservers.
4. After returning the response from the nameservers, Cloudflare temporarily caches it for subsequent DNS queries.

***

## Benefits

DNS Firewall provides the following benefits while allowing your organization total control over your authoritative nameservers:

* DDoS mitigation
* High availability
* Global distribution
* Enhanced performance
* Bandwidth savings
* [Rate limiting per data center](https://developers.cloudflare.com/dns/dns-firewall/setup/#additional-options)
* Minimum and maximum cache TTL specification
* DNS [ANY](https://datatracker.ietf.org/doc/html/rfc8482) query type block
