---
title: R2 Object Storage · Cloudflare Data Localization Suite docs
description: In the following sections, we will give you some details about how
  to configure R2 with Regional Services and Customer Metadata Boundary.
lastUpdated: 2025-09-03T10:05:39.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/data-localization/how-to/r2/
  md: https://developers.cloudflare.com/data-localization/how-to/r2/index.md
---

In the following sections, we will give you some details about how to configure R2 with Regional Services and Customer Metadata Boundary.

## Regional Services

To configure Regional Services for hostnames [proxied](https://developers.cloudflare.com/dns/proxy-status/) through Cloudflare and ensure that processing of requesting objects from a [R2 Bucket](https://developers.cloudflare.com/r2/buckets/) occurs only in-region, follow these steps:

1. In the Cloudflare dashboard, go to the **R2** page.

   [Go to **Overview**](https://dash.cloudflare.com/?to=/:account/r2/overview)

2. Follow the steps to [create a Bucket](https://developers.cloudflare.com/r2/buckets/create-buckets/).

3. [Connect a bucket to a custom domain](https://developers.cloudflare.com/r2/buckets/public-buckets/#connect-a-bucket-to-a-custom-domain).

4. Run the [API POST](https://developers.cloudflare.com/data-localization/regional-services/get-started/#configure-regional-services-via-api) command on the configured bucket custom domain to create a `regional_hostnames` with a specific region.

Regional Services only applies to the custom domain configured for an R2 Bucket.

### Send logs to R2 via S3-Compatible endpoint

The following instructions will show you how to set up a Logpush job using an S3-compatible endpoint to store logs in an R2 bucket in the jurisdiction of your choice.

1. Create an [R2 bucket](https://developers.cloudflare.com/r2/get-started/) in your Cloudflare account and select the [jurisdiction](https://developers.cloudflare.com/r2/reference/data-location/#set-jurisdiction-via-the-cloudflare-dashboard) you would like to use.

2. Generate an API token for your R2 bucket. You have the following two options:

Generate a token for a specific bucket (recommended)

Go to the R2 section of your Cloudflare dashboard and select **Manage R2 API Tokens** to generate a token directly tied to your specific bucket. You can follow the instructions in the [Authentication](https://developers.cloudflare.com/r2/api/tokens/) section.

Generate a token for all buckets

You can generate a API token in **Manage Account** > **Account API Tokens** or you can create a user-specific token:

1. Go to **My Profile** > **API Tokens**
2. Select **Create Token** > **Create Custom Token**
3. Choose **Account** > **Workers R2 Storage** > **Edit** to set permissions.
4. To test your token, copy the `curl` command and paste it into a terminal.

```bash
curl "https://api.cloudflare.com/client/v4/user/tokens/verify" \
--header "Authorization: Bearer <API_TOKEN>"
```

The result:

```json
{
  "result": {
    "id": "325xxxxcd",
    "status": "active"
  },
  "success": true,
  "errors": [],
  "messages": [
    {
      "code": 10000,
      "message": "This API Token is valid and active",
      "type": null
    }
  ]
}
```

1. Generate a SHA-256 hash of the token:

```bash
echo -n "<token>" | shasum -a 256
```

This command will output a hash similar to `dxxxx391b`.

1. Set up a Logpush destination using [S3-compatible endpoint](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/s3-compatible-endpoints/) and fill in the following fields:

* **Bucket**: Enter the name of the R2 bucket you created with the jurisdiction you would like to use.
* **Path** (optional): If you want, you can specify a folder path to organize your logs.
* **Endpoint URL**: Provide the S3 API endpoint for your bucket in the format `<account-id>.eu.r2.cloudflarestorage.com`. Do not include the bucket name, as it was set in the first field.
* **Bucket Region**: For instance, use `WEUR` to specify the EU region.
* **Access Key ID**: Enter the Token ID created previously (`325xxxxcd`).
* **Secret Access Key**: Use the SHA-256 hash of the token (`dxxxx391b`).

Complete the configuration by selecting the fields you want to push to your R2 bucket.

## Customer Metadata Boundary

With Customer Metadata Boundary set to `EU`, **R2** > **Bucket** > [**Metrics**](https://developers.cloudflare.com/r2/platform/metrics-analytics/) tab in the account dashboard will be populated.

Note

Additionally, customers can create R2 buckets with [jurisdictional restrictions set to EU](https://developers.cloudflare.com/r2/reference/data-location/#jurisdictional-restrictions). In this case, we recommend [using jurisdictions with the S3 API](https://developers.cloudflare.com/r2/reference/data-location/#using-jurisdictions-with-the-s3-api).

Refer to the [R2 documentation](https://developers.cloudflare.com/r2/) for more information.
