---
title: WARP with legacy VPN · Cloudflare One docs
description: "The Cloudflare WARP client can run alongside most legacy
  third-party VPNs. Because the WARP client and third-party VPN client both
  enforce firewall, routing, and DNS rules on your local device, the two
  products will compete with each other for control over IP and DNS traffic. To
  ensure compatibility make sure that:"
lastUpdated: 2025-10-21T14:33:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/vpn/
  md: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/vpn/index.md
---

The Cloudflare WARP client can run alongside most legacy third-party VPNs. Because the WARP client and third-party VPN client both enforce firewall, routing, and DNS rules on your local device, the two products will compete with each other for control over IP and DNS traffic. To ensure compatibility make sure that:

* IP traffic is split tunneled between WARP and the VPN. All VPN traffic must bypass WARP and vice versa.
* The VPN bypasses/allows/excludes all domains, IPs, and ports listed in [WARP with firewall](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/).
* DNS resolution is handled by either WARP or the VPN. You must disable DNS filtering in one of the two products.

For the most stable and consistent connection, we recommend connecting your [private network or individual applications](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/) to Cloudflare instead of using a legacy VPN. However, until you can migrate, the following guidelines will help get your Zero Trust deployment up and running.

## Gateway with WARP

In [Gateway with WARP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#gateway-with-warp-default) mode, WARP must be allowed to capture and route all DNS traffic on the device. You can use [Local Domain Fallback](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/) to send DNS requests to a server behind your third-party VPN or firewall, but the request must first go through WARP's local DNS proxy. Refer to [WARP architecture](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/) for more information about this requirement.

If you cannot disable DNS on your VPN, switch to [Secure Web Gateway without DNS filtering](#secure-web-gateway-without-dns-filtering) mode to disable DNS in WARP.

### 1. Configure the VPN

Perform these steps in your third-party VPN software. Refer to your VPN's documentation for specific instructions on how to configure these settings.

1. Enable split tunneling in the third-party VPN.

2. Disable DNS configuration in the third-party VPN.

### 2. Configure WARP

Perform these steps in [Cloudflare One](https://one.dash.cloudflare.com/).

1. Set your [Split Tunnels mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/#change-split-tunnels-mode) to **Exclude IPs and domains**.

2. [Add the following entries](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/#add-a-route) to your Split Tunnel Exclude list:

   * Private IP address range exposed by your third-party VPN client. For example,

     | Selector | Value |
     | - | - |
     | IP Address | `172.16.0.0/12` |
     | | |

   * Server that your third-party VPN client connects to. For example,

     | Selector | Value |
     | - | - |
     | Domain | `*.cvpn-endpoint-xxxxx.prod.clientvpn.us-west-2.amazonaws.com` |

1) (Optional) In [Local Domain Fallback](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/), add the domains that you want to resolve using your VPN's private DNS servers. For example,

   | Domain | DNS Servers |
   | - | - |
   | `internal.wiki.intranet` | `172.31.26.130`, `172.31.23.120` |

You can now [test](#test-the-configuration) if WARP runs alongside the VPN.

## Secure Web Gateway without DNS filtering

In [Secure Web Gateway without DNS filtering](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#secure-web-gateway-without-dns-filtering) mode, WARP does not perform any DNS functions on the device. Therefore, all you need to do is split tunnel your IP traffic.

### 1. Configure the VPN

Enable split tunneling in your third-party VPN software. Refer to your VPN's documentation for specific instructions on how to configure this setting.

### 2. Configure WARP

Perform these steps in [Cloudflare One](https://one.dash.cloudflare.com/).

1. Set your [Split Tunnels mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/#change-split-tunnels-mode) to **Exclude IPs and domains**.

2. [Add the following entries](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/#add-a-route) to your Split Tunnel Exclude list:

   * Private IP address range exposed by your third-party VPN client. For example,

     | Selector | Value |
     | - | - |
     | IP Address | `172.16.0.0/12` |
     | | |

   * Server that your third-party VPN client connects to. For example,

     | Selector | Value |
     | - | - |
     | Domain | `*.cvpn-endpoint-xxxxx.prod.clientvpn.us-west-2.amazonaws.com` |

1) In your device profile, verify that **Service mode** is set to **Secure Web Gateway without DNS filtering**.

## Test the configuration

We recommend enabling the WARP client before enabling your third-party VPN. Some third-party VPNs must be the last to edit a network's configuration or they will fail.

1. Connect the WARP client.
2. Connect the third-party VPN client.
3. To test your Split Tunnel configuration, connect to a private IP address that is behind the VPN. For example, you can open a terminal and run `ping <SERVER-IP>`.
4. To test your DNS configuration, connect to an internal domain that is behind the VPN. For example, you can open a browser and go to `internal.wiki.intranet`.

Test before updates

Once you have a configuration in place and working, make sure to thoroughly test compatibility before updating your VPN software. Compatibility testing with what are essentially competing software will need to be done with each new version.
