---
title: WAF Release - 2025-11-24 · Changelog
description: Cloudflare WAF managed rulesets 2025-11-24 release
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-11-24-waf-release/
  md: https://developers.cloudflare.com/changelog/2025-11-24-waf-release/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## WAF Release - 2025-11-24

Nov 24, 2025

[WAF](https://developers.cloudflare.com/waf/)

This week highlights enhancements to detection signatures improving coverage for vulnerabilities in FortiWeb, linked to CVE-2025-64446, alongside new detection logic expanding protection against PHP Wrapper Injection techniques.

**Key Findings**

This vulnerability enables an unauthenticated attacker to bypass access controls by abusing the `CGIINFO` header. The latest update strengthens detection logic to ensure a reliable identification of crafted requests attempting to exploit this flaw.

**Impact**

* FortiWeb (CVE-2025-64446): Exploitation allows a remote unauthenticated adversary to circumvent authentication mechanisms by sending a manipulated `CGIINFO` header to FortiWeb’s backend CGI handler. Successful exploitation grants unintended access to restricted administrative functionality, potentially enabling configuration tampering or system-level actions.

| Ruleset | Rule ID | Legacy Rule ID | Description | Previous Action | New Action | Comments |
| - | - | - | - | - | - | - |
| Cloudflare Managed Ruleset | b957ace6e9844bf29244401c4e2e1a2e | N/A | FortiWeb - Authentication Bypass via CGIINFO Header - CVE:CVE-2025-64446 | Log | Block | This is a new detection |
| Cloudflare Managed Ruleset | e3871391a93248fa98a78e03b6c44ed5 | N/A | PHP Wrapper Injection - Body - Beta | Log | Disabled | This rule has been merged into the original rule "PHP Wrapper Injection - Body" (ID:fae6fa37ae9249d58628e54b1a3e521e ) |
| Cloudflare Managed Ruleset | e6b1b66e0e3b46969102baed900f4015 | N/A | PHP Wrapper Injection - URI - Beta | Log | Disabled | This rule has been merged into the original rule "PHP Wrapper Injection - URI" (ID:9c02e585db34440da620eb668f76bd74 ) |
